//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Xml;
using System.Xml.Serialization;
using System.IO;

namespace MultiLevelXML
{
	public class Person
	{
		[XmlAttribute]
		public string name;
		[XmlAttribute]
		public double age;
	}

	public class Marriage
	{
		public Person husband;
		public Person wife;
	}

	public class Family
	{
		public Marriage couple;
		public Person [] children;
	}

	/// <summary>
	///    Podsumowanie dla MultiLevelSerialization.
	/// </summary>
	public class MultiLevelSerialization
	{
		public static int Main(string[] args)
		{
			Person me = new Person();
			me.age = 43;
			me.name = "Kevin";

			Person wife = new Person();
			wife.age = 50;
			wife.name = "Becky";

			Marriage marriage = new Marriage();
			marriage.husband = me;
			marriage.wife = wife;

			// Utworzenie egzemplarza klasy XmlSerializer;
			// wybr typu obiektu do szeregowania.
			XmlSerializer serializer = 
				new XmlSerializer(typeof(Marriage));
			StreamWriter writer = new StreamWriter("out1.xml");
			serializer.Serialize(writer, marriage);
			writer.Close();

			Family burton = new Family();
			burton.couple = marriage;

			burton.children = new Person[4];
			burton.children[0] = new Person();
			burton.children[0].age = 20;
			burton.children[0].name = "Sarah";
			burton.children[1] = new Person();
			burton.children[1].age = 18;
			burton.children[1].name = "Ann Marie";
			burton.children[2] = new Person();
			burton.children[2].age = 17;
			burton.children[2].name = "Mike";
			burton.children[2] = new Person();
			burton.children[2].age = 13;
			burton.children[2].name = "Rose";

			// Utworzenie egzemplarza klasy XmlSerializer;
			// wybr typu obiektu do szeregowania.
			serializer = 
				new XmlSerializer(typeof(Family));
			writer = new StreamWriter("out2.xml");
			serializer.Serialize(writer, burton);
			writer.Close();

			return 0;
		}
	}
}

